/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.report;

import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueType;
import com.quantumdata.fmteditor.fmt.Format;
import com.quantumdata.fmteditor.report.FmtReport;
import com.quantumdata.fmteditor.report.FmtTableEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmtTableModel
extends AbstractTableModel {
    private static final int NAME_COL = 0;
    private Vector<CmdValue> m_colValues = new Vector();
    private Vector<SortMode> m_colSort = new Vector();
    private Vector<FmtTableEntry> m_rows = new Vector();
    private Format m_fmt = new Format();

    public FmtTableModel() {
        this.m_fmt.addValue(new CmdValue(CmdValueType.DOUBLE, "VRAT", 0.0, "Vertical Rate"));
        this.m_fmt.addValue(new CmdValue(CmdValueType.DOUBLE, "PRAT", 0.0, "Pixel Rate (MHz)"));
        this.m_fmt.addValue(new CmdValue(CmdValueType.DOUBLE, "FRAT", 0.0, "Frame Rate"));
        this.m_fmt.addValue(new CmdValue(CmdValueType.INT, "HBPD", 0.0, "Horiz. Broad Pulse Delay"));
        this.m_fmt.addValue(new CmdValue(CmdValueType.INT, "HBPW", 0.0, "Horiz. Broad Pulse Width"));
        this.m_fmt.addValue(new CmdValue(CmdValueType.INT, "VBNK", 0.0, "Vertical Blanking"));
        this.m_fmt.addValue(new CmdValue(CmdValueType.INT, "HBNK", 0.0, "Horizontal Blanking"));
        this.m_fmt.addValue(new CmdValue(CmdValueType.INT, "VSPB", 0.0, "Vertical Sync Backporch"));
        this.m_fmt.addValue(new CmdValue(CmdValueType.INT, "HSPB", 0.0, "Horizontal Sync Backporch"));
        this.m_colSort.add(SortMode.NONE);
    }

    @Override
    public int getColumnCount() {
        return this.m_colValues.size() + 1;
    }

    public SortMode getSortMode(int n) {
        return this.m_colSort.get(n);
    }

    public Vector<CmdValue> getColumnValues() {
        return this.m_colValues;
    }

    @Override
    public int getRowCount() {
        if (this.m_rows == null) {
            return 0;
        }
        return this.m_rows.size();
    }

    public FmtTableEntry getRow(int n) {
        if (n >= this.m_rows.size()) {
            return null;
        }
        return this.m_rows.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        FmtTableEntry fmtTableEntry = this.m_rows.elementAt(n);
        if (n2 == 0) {
            return fmtTableEntry.name();
        }
        return fmtTableEntry.getValue(this.m_colValues.get(n2 - 1).getName());
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "Name";
        }
        CmdValue cmdValue = this.m_colValues.get(n - 1);
        if (cmdValue.getDescription().length() > 0) {
            return cmdValue.getDescription();
        }
        return cmdValue.getName();
    }

    public void setCapacity(int n) {
        this.m_rows.ensureCapacity(n);
    }

    public Format getReferenceFormat() {
        return this.m_fmt;
    }

    public void clearColumns() {
        this.m_colValues.clear();
        this.m_colSort.clear();
        this.m_colSort.add(SortMode.NONE);
        this.fireTableStructureChanged();
    }

    public void addColumn(String string) {
        CmdValue cmdValue = this.m_fmt.getValue(string);
        if (cmdValue == null) {
            return;
        }
        this.m_colValues.add(cmdValue.clone());
        this.m_colSort.add(SortMode.NONE);
        this.fireTableStructureChanged();
    }

    public void removeColumn(String string) {
        int n = 0;
        for (CmdValue cmdValue : this.m_colValues) {
            if (cmdValue.getName().equalsIgnoreCase(string)) {
                this.m_colValues.removeElement(cmdValue);
                this.m_colSort.remove(n + 1);
                this.fireTableStructureChanged();
                return;
            }
            ++n;
        }
    }

    public void clear() {
        int n = this.m_rows.size();
        if (n == 0) {
            return;
        }
        this.m_rows.clear();
        this.fireTableRowsDeleted(0, n - 1);
    }

    public void addEntry(FmtTableEntry fmtTableEntry) {
        this.m_rows.add(fmtTableEntry);
    }

    public void addRow(FmtReport.Row row) {
        CmdValue[] cmdValueArray = new CmdValue[this.m_colValues.size()];
        int n = 0;
        for (CmdValue cmdValue : this.m_colValues) {
            cmdValueArray[n] = cmdValue.clone();
            cmdValueArray[n].setDoubleQuite(row.getValues()[n]);
            ++n;
        }
        this.m_rows.add(new FmtTableEntry(row.getPath(), row.getName(), cmdValueArray));
    }

    public void entriesCompleted() {
        int n = this.m_rows.size();
        if (n == 0) {
            return;
        }
        this.fireTableRowsInserted(0, n - 1);
    }

    public FmtTableEntry getEntry(int n) {
        if (n >= this.m_rows.size()) {
            return null;
        }
        return this.m_rows.get(n);
    }

    public void sortOnColumn(int n) {
        if (this.m_rows.size() == 0) {
            return;
        }
        SortMode sortMode = this.m_colSort.get(n);
        switch (sortMode) {
            case NONE: {
                sortMode = SortMode.ASCENDING;
                break;
            }
            case ASCENDING: {
                sortMode = SortMode.DESCENDING;
                break;
            }
            case DESCENDING: {
                sortMode = SortMode.ASCENDING;
            }
        }
        for (int i = 0; i < this.m_colSort.size(); ++i) {
            this.m_colSort.set(i, SortMode.NONE);
        }
        this.m_colSort.set(n, sortMode);
        Collections.sort(this.m_rows, new RowSorter(n, sortMode));
        this.fireTableDataChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowSorter
    implements Comparator<FmtTableEntry> {
        private int m_column;
        private SortMode m_mode;

        public RowSorter(int n, SortMode sortMode) {
            this.m_column = n;
            this.m_mode = sortMode;
        }

        @Override
        public int compare(FmtTableEntry fmtTableEntry, FmtTableEntry fmtTableEntry2) {
            int n = 0;
            if (this.m_column == 0) {
                n = -fmtTableEntry.name().compareTo(fmtTableEntry2.name());
            } else {
                CmdValue cmdValue = fmtTableEntry.getValue(this.m_column - 1);
                CmdValue cmdValue2 = fmtTableEntry2.getValue(this.m_column - 1);
                n = (int)Math.round(cmdValue.getDouble() - cmdValue2.getDouble());
            }
            if (this.m_mode == SortMode.DESCENDING) {
                n = -n;
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortMode {
        NONE,
        ASCENDING,
        DESCENDING;

    }
}

